/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.nhm.eui.CutPasteTextArea;
import ibm.nways.nhm.eui.MyMenuBar;
import ibm.nways.nhm.eui.NhmHelpRef;
import ibm.nways.nhm.eui.NhmReportDialog;
import ibm.nways.nhm.file_server.RemoteInputStream;
import ibm.nways.nhm.file_server.RemoteOutputStream;
import ibm.nways.ras.Traces;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import jclass.bwt.JCTextArea;

public class ReportEditorFrame
extends Frame
implements WindowListener,
ActionListener {
    private Applet applet;
    private MenuItem saveReport;
    private MenuItem saveAsReport;
    private MenuItem openReport;
    private MenuItem miExit;
    private MenuItem miCut;
    private MenuItem miCopy;
    private MenuItem miPaste;
    private MenuItem stdHeader;
    private MenuItem stdTrailer;
    private MenuItem helpIndex;
    private CutPasteTextArea editArea;
    private String reportName;
    private JCTextArea childTextArea;
    private Button childSaveButton;
    private Button childCancelButton;
    private Frame childFrame;
    private int serverPort;
    private boolean bEditingHeader = false;
    private boolean bEditingTrailer = false;
    private static char SEPARATOR = (char)47;
    private static String HEADER_NAME = "reports" + File.separator + "standard_header.html";
    private static String TRAILER_NAME = "reports" + File.separator + "standard_trailer.html";
    private ResourceBundle nhmRes = ResourceBundle.getBundle("ibm.nways.nhm.eui.NhmResources");

    public ReportEditorFrame(String string, Applet applet, int n) {
        super.setTitle(string);
        this.reportName = string;
        this.serverPort = n;
        this.applet = applet;
        this.initialize();
    }

    protected void initialize() {
        this.setLayout(new BorderLayout());
        this.constructMenu();
        this.editArea = new CutPasteTextArea(15, 55);
        this.editArea.setPreferredSize(450, 560);
        this.editArea.setBackground(Color.white);
        this.editArea.setForeground(Color.black);
        this.add("Center", this.editArea);
        this.addWindowListener(this);
        this.pack();
    }

    public void loadFile() {
        if (this.reportName != null && this.reportName.length() != 0) {
            Cursor cursor = this.getCursor();
            Cursor cursor2 = new Cursor(3);
            Cursor cursor3 = this.editArea.getCursor();
            ((Component)this).setCursor(cursor2);
            this.editArea.setCursor(cursor2);
            this.fillTextAreaFromFile(this.editArea, "reports" + File.separator + this.reportName + ".html", false);
            if (this.editArea.getText().length() == 0) {
                this.fillTextAreaFromFile(this.editArea, HEADER_NAME, false);
                this.fillTextAreaFromFile(this.editArea, TRAILER_NAME, true);
            }
            ((Component)this).setCursor(cursor);
            this.editArea.setCursor(cursor3);
        }
    }

    protected int fillTextAreaFromFile(JCTextArea jCTextArea, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(500);
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream((InputStream)new RemoteInputStream(string, this.applet.getDocumentBase().getHost(), this.serverPort));
            try {
                int n;
                while ((n = dataInputStream.read()) != -1) {
                    stringBuffer.append((char)n);
                }
            }
            catch (EOFException eOFException) {
                System.out.println("EOF");
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Traces.logError(this, "Error on getInStream: ");
            Traces.logException(exception);
            try {
                if (dataInputStream != null) {
                    dataInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (bl) {
            jCTextArea.append(stringBuffer.toString());
        } else {
            jCTextArea.setText(stringBuffer.toString());
        }
        return stringBuffer.length();
    }

    protected void constructMenu() {
        MyMenuBar myMenuBar = new MyMenuBar();
        Menu menu = new Menu(this.nhmRes.getString("s_Rpt"));
        myMenuBar.add(menu);
        this.openReport = new MenuItem(this.nhmRes.getString("s_Open"));
        this.saveReport = new MenuItem(this.nhmRes.getString("s_Save"));
        this.saveAsReport = new MenuItem(this.nhmRes.getString("s_SaveAs"));
        this.miExit = new MenuItem(this.nhmRes.getString("s_Exit"));
        menu.add(this.openReport);
        menu.add(this.saveReport);
        menu.add(this.saveAsReport);
        menu.addSeparator();
        menu.add(this.miExit);
        menu = new Menu(this.nhmRes.getString("s_Edit"));
        myMenuBar.add(menu);
        this.miCut = new MenuItem(this.nhmRes.getString("s_Cut"));
        this.miCopy = new MenuItem(this.nhmRes.getString("s_Copy"));
        this.miPaste = new MenuItem(this.nhmRes.getString("s_Paste"));
        menu.add(this.miCut);
        menu.add(this.miCopy);
        menu.add(this.miPaste);
        menu.addSeparator();
        this.stdHeader = new MenuItem(this.nhmRes.getString("s_EditHdr"));
        this.stdTrailer = new MenuItem(this.nhmRes.getString("s_EditTrlr"));
        menu.add(this.stdHeader);
        menu.add(this.stdTrailer);
        menu = new Menu(this.nhmRes.getString("s_Help"));
        myMenuBar.add(menu);
        this.helpIndex = new MenuItem(this.nhmRes.getString("s_HelpIndex"));
        menu.add(this.helpIndex);
        myMenuBar.setHelpMenu(menu);
        this.setMenuBar(myMenuBar);
        myMenuBar.listenOnAll(this);
    }

    protected void saveTextAreaToFile(JCTextArea jCTextArea, String string) {
        PrintWriter printWriter = null;
        try {
            RemoteOutputStream remoteOutputStream = new RemoteOutputStream(string, this.applet.getDocumentBase().getHost(), this.serverPort);
            printWriter = new PrintWriter((OutputStream)remoteOutputStream);
            printWriter.print(jCTextArea.getText());
            printWriter.close();
            return;
        }
        catch (Exception exception) {
            Traces.logError(this, "Exception received in saveTextAreaToFile");
            Traces.logException(exception);
            if (printWriter != null) {
                printWriter.close();
            }
            return;
        }
    }

    protected void saveReport() {
        this.saveTextAreaToFile(this.editArea, "reports" + File.separator + this.reportName + ".html");
    }

    protected void editHeaderOrTrailer(String string) {
        this.childFrame = new Frame(string);
        this.childFrame.setLayout(new BorderLayout());
        this.childTextArea = new JCTextArea();
        this.childFrame.add("Center", this.childTextArea);
        Panel panel = new Panel();
        this.childSaveButton = new Button(this.nhmRes.getString("s_Save"));
        this.childCancelButton = new Button(this.nhmRes.getString("s_Dismiss"));
        panel.add(this.childSaveButton);
        panel.add(this.childCancelButton);
        this.childFrame.add("South", panel);
        this.childSaveButton.addActionListener(this);
        this.childCancelButton.addActionListener(this);
        this.fillTextAreaFromFile(this.childTextArea, string, false);
        this.childFrame.addWindowListener(this);
        Rectangle rectangle = this.getBounds();
        rectangle.x += 50;
        rectangle.y += 50;
        rectangle.height = 400;
        rectangle.width = 450;
        ((Component)this.childFrame).setBounds(rectangle);
        this.childFrame.show();
    }

    protected void saveAsReport() {
        NhmReportDialog nhmReportDialog = new NhmReportDialog(this, 4, this.applet, this.applet.getDocumentBase().getHost(), this.serverPort);
        nhmReportDialog.setReportName(this.reportName);
        nhmReportDialog.show();
        while (nhmReportDialog.getResult() == 4 && nhmReportDialog.getReportName().length() == 0) {
            nhmReportDialog.show();
        }
        if (nhmReportDialog.getResult() == 4 && nhmReportDialog.getReportName().length() > 0) {
            this.reportName = nhmReportDialog.getReportName();
            this.saveReport();
            this.setTitle(this.reportName);
        }
        nhmReportDialog.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.saveAsReport) {
            this.saveAsReport();
            return;
        }
        if (actionEvent.getSource() == this.saveReport) {
            if (this.reportName.length() == 0) {
                this.saveAsReport();
                return;
            }
            this.saveReport();
            return;
        }
        if (actionEvent.getSource() == this.openReport) {
            NhmReportDialog nhmReportDialog = new NhmReportDialog(this, 5, this.applet, this.applet.getDocumentBase().getHost(), this.serverPort);
            nhmReportDialog.show();
            if (nhmReportDialog.getResult() == 5 && nhmReportDialog.getReportName().length() > 0) {
                this.reportName = nhmReportDialog.getReportName();
                this.loadFile();
                this.setTitle(this.reportName);
            }
            nhmReportDialog.dispose();
            return;
        }
        if (actionEvent.getSource() == this.miExit) {
            this.dispose();
            return;
        }
        if (actionEvent.getSource() == this.miCut) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            this.editArea.cutToClipboard(clipboard);
            return;
        }
        if (actionEvent.getSource() == this.miCopy) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            this.editArea.copyToClipboard(clipboard);
            return;
        }
        if (actionEvent.getSource() == this.miPaste) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            this.editArea.pasteFromClipboard(clipboard);
            return;
        }
        if (actionEvent.getSource() == this.stdHeader) {
            this.stdHeader.setEnabled(false);
            this.stdTrailer.setEnabled(false);
            this.editHeaderOrTrailer(HEADER_NAME);
            this.bEditingHeader = true;
            return;
        }
        if (actionEvent.getSource() == this.stdTrailer) {
            this.stdHeader.setEnabled(false);
            this.stdTrailer.setEnabled(false);
            this.editHeaderOrTrailer(TRAILER_NAME);
            this.bEditingTrailer = true;
            return;
        }
        if (actionEvent.getSource() == this.helpIndex) {
            NhmHelpRef nhmHelpRef = new NhmHelpRef(this);
            if (this.applet instanceof BrowserApplet) {
                BrowserApplet browserApplet = (BrowserApplet)this.applet;
                browserApplet.showHelp(nhmHelpRef);
                return;
            }
            this.applet.getAppletContext().showDocument(nhmHelpRef.getURL(this.applet));
            return;
        }
        if (actionEvent.getSource() == this.childSaveButton) {
            if (this.bEditingHeader) {
                this.saveTextAreaToFile(this.childTextArea, HEADER_NAME);
                return;
            }
            if (this.bEditingTrailer) {
                this.saveTextAreaToFile(this.childTextArea, TRAILER_NAME);
                return;
            }
        } else if (actionEvent.getSource() == this.childCancelButton) {
            this.childFrame.dispose();
            this.childTextArea = null;
            this.childSaveButton = null;
            this.childCancelButton = null;
            this.childFrame = null;
            this.stdHeader.setEnabled(true);
            this.stdTrailer.setEnabled(true);
            this.bEditingTrailer = false;
            this.bEditingHeader = false;
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this) {
            this.dispose();
        }
        if (windowEvent.getWindow() == this.childFrame) {
            this.childFrame.dispose();
            this.childTextArea = null;
            this.childSaveButton = null;
            this.childCancelButton = null;
            this.childFrame = null;
            this.stdHeader.setEnabled(true);
            this.stdTrailer.setEnabled(true);
            this.bEditingTrailer = false;
            this.bEditingHeader = false;
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

